#include <REG52.H>                     // for sfr PCON(8051)

union WTYPE
  { BYTE B[2];
    WORD W;
  };
  
union DWTYPE
  { BYTE B[4];
    WORD W[2];
    DWORD DW;
  };


//-----MUC.C-----//
sfr        WDTCR          =    0xE1;             // Watch Dog Timer Control Register
sfr        P2M0           =    0x95;
sfr        P2M1           =    0x96;
sfr        SICON          =    0xF8;             // SFR for IIC
                #define    CR0         0x01      // 
                #define    CR1         0x02      // 
                #define    AA          0x04      // 
                #define    SI          0x08      // 
                #define    STO         0x10      // 
                #define    STA         0x20      // 
                #define    ENTWAI      0x40      // 
                #define    CR2         0x80      // 
sfr        SIDAT          =    0xD2;             // SFR for IIC
sfr        AUXR2          =    0xA6;             //
                #define    T0CKOE      0x01
		#define    URM0X6      0x20      // Serial Port mode 0 baud rate select. Set to select Fosc/2.
		#define    T1X12       0x40      // Set to select Fosc as the clock source, and clear to select Fosc/12
		#define    T0X12       0x80      // 
sfr        AUXIE          =    0xAD;             //
		#define    EKB         0x20
		#define    EUSB        0x80
sfr        AUXIP          =    0xAE;
		#define    PKB         0x20
		#define    PUSB        0x80
sfr        P3M0           =    0xB1;             //
sfr        P3M1           =    0xB2;             //
sfr        XICON          =    0xC0;
		#define       IT3      0x10      // 
		#define       IE3      0x20      // 
		#define       EX3      0x40      // 
		#define       IL3      0x80      //
sfr        CKCON          =    0xC7;
                #define    CKS0        0x01
                #define    CKS1        0x02
sfr        CKCON2         =    0xBF;
		#define    CK_SEL      0x01
		#define    PLL_RDY     0x02
		#define    EN_PLL      0x04
		#define    EN_USB      0x08

//-----USB.C-----//
//sbit       VBUS_IN        =    P3^7;             // High -> USB Connected
sbit       USBLED         =    P3^5;             // Low Active

//-----USB.C ( Speakdr )-----//
sbit       MUTELED        =    P3^6;             // Low Active

sbit       VOL_INC_IN     =    P1^0;             // Detect Pin
sbit       VOL_DEC_IN     =    P1^1;             // Detect Pin
sbit       VOL_MUTE_IN    =    P1^2;             // Detect Pin

sbit       KEY_PLAYPAUSE  =    P3^0;             // Detect Pin
sbit       KEY_NEXT       =    P3^1;             // Detect Pin
sbit       KEY_PREVIOUS   =    P3^2;             // Detect Pin
sbit       KEY_STOP       =    P3^3;             // Detect Pin
sbit       KEY_MEDIAPLAY  =    P3^4;             // Detect Pin

//-----DFU.C-----//
sfr        IFD            =    0xE2;
sfr        IFADRH         =    0xE3;
sfr        IFADRL         =    0xE4;
sfr        IFMT           =    0xE5;
sfr        SCMD           =    0xE6;
sfr        ISPCR          =    0xE7;